Garrett Wilson (WR1, NYJ) – 2025 outlook: concise, data-backed points and actionable takeaways

Overall stance
- High upside if Jets throw at a healthy rate and Wilson retains feature-target status, but massive offense/quarterback risk; not a safe floor pick at current ADP.
- Expect volatility: solid target volume possible, but TDs and overall passer volume are the key swing factors.

Target share, volume, and role
- TS/volume: Potential 25%+ target share is plausible, but total Jets pass attempts are uncertain. Some commentary assumes Wilson could be peppered (roughly 138 targets discussed in contrast to 154 last year), with the caveat that overall pass volume may drop.
- Likely targets behind him: Mason Taylor (Jets TE) projected to finish second in targets; Lazard and Reynolds also in mix. This reduces Wilson’s floor vs. a true “no-competition” scenario.
- Expected targets: 140–160 range is a reasonable projection if the offense remains pass-heavy; 70–90 receptions possible depending on efficiency and target distribution.
- Yards: 1,000–1,300 range is plausible given target volume and QB play, though efficiency could swing this.

Touchdowns and scoring
- TDs: Likely regression from 7 TDs, especially if the offense doesn’t sustain high red-zone volume. Expect 5–8 TDs range unless offense improves dramatically or TE/WR trio cannibalizes red-zone targets.
- PPR scoring outlook depends heavily on target volume and TD rate; floor is riskier than a typical WR1 due to Jets’ offense volatility.

Quarterback/Offense risk
- Justin Fields as passer is a major uncertainty. Two-read tendencies and limited progression can lead to boom/bust weeks; Wilson’s week-to-week consistency is more volatile than typical WR1s.
- Jets’ overall passing volume could be below league-average if the offense leans run-heavy or if QB progressions stagnate.

Roster construction and draft value
- ADP reality: Around WR17 (NFFC-like data shows a prominent late-2nd round price). That’s near Wilson’s ceiling in some scenarios but could be a misprice if your league assumes 150-target seasons.
- Value/price dynamics: In many formats, Wilson is a high-variance WR2 with top-10 upside if the offense supports a 140–160 target year. In 14-team or “STACKED” builds, he can be a sensible mid-round pick but not a must-have in every format.
- Avoid/sell-high concerns: FF Hound and other takes warn against overpaying for Jets pass-catchers in a stinky passing game; Wilson’s value is tightly tied to the offense’s efficiency and volume.

What to monitor in 2025
- Mason Taylor’s target trajectory (backup TE): If Taylor siphons more targets, Wilson’s ceiling could compress; if Taylor underwhelms, Wilson could push toward the higher end of his range.
- Jets camp notes on Lazard/Reynolds use and any shifts in WR1/WR2 roles.
- Early preseason efficiency and red-zone usage to gauge TD upside.
- Any change in Jets’ play-calling to push more volume through Wilson vs. alternate targets.

Draft strategy tips
- If you’re opting for Wilson, pair with a high-floor, high-volume QB or another offense with steadier passing in a best-ball/lineup-rich format to mitigate volatility.
- In 2WR leagues, consider him as a WR2 with a clear boom/bust profile; in 3WR leagues or deeper formats, he’s more palatable as a top-tier WR3 with upside.
- Don’t reach well above ADP; in spots where Mason Taylor’s role is uncertain, Wilson’s value could swing both ways week-to-week.
- If you’re risk-averse, consider avoiding Jets WRs entirely in drafts that already have multiple uncertain pass-catchers; if you’re willing to chase upside, Wilson is one of the few Jets players with a realistic top-10 ceiling.

Bottom line
- Wilson is a high-upside, high-variance pick in 2025. He can deliver top-12 WR numbers if the Jets’ passing volume stays healthy and he maintains a lead target share, but the combination of quarterback uncertainty, competition for targets, and potential TD regression makes him a riskier, mid-round bet. Use him as a value-play only if you’re confident in the Jets’ offense and you’ve built a hedge for weeks where the passing game stalls.